<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Utils;

use Magento\Rule\Model\Condition\AbstractCondition;

class ConditionAttributesFormatter
{
    public function format(AbstractCondition $condition, array $restrictedAttributes = []): array
    {
        $attributes = [];
        $conditionClass = get_class($condition);

        foreach ($condition->loadAttributeOptions()->getAttributeOption() as $attrCode => $attrLabel) {
            if (in_array($attrCode, $restrictedAttributes)) {
                continue;
            }
            $attributes[] = [
                'value' => $conditionClass . '|' . $attrCode,
                'label' => $attrLabel,
            ];
        }

        return $attributes;
    }
}
