<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Product\Subselect;

use Amasty\Segments\Helper\Condition\Data;
use Amasty\Segments\Model\Rule\Condition\Product\Subselect;
use Amasty\Segments\Model\Rule\Utils\ConditionAttributesFormatter;
use Magento\CatalogRule\Model\Rule\Condition\Product as CatalogRuleProduct;
use Magento\Rule\Model\Condition\Context;
use Magento\Wishlist\Model\WishlistFactory;

class Wishlist extends Subselect
{
    /**
     * @var WishlistFactory
     */
    protected $wishlistFactory;

    public function __construct(
        Context $context,
        CatalogRuleProduct $conditionCatalog,
        ConditionAttributesFormatter $attributesFormatter,
        WishlistFactory $wishlistFactory,
        array $data = []
    ) {
        parent::__construct($context, $conditionCatalog, $attributesFormatter, $data);
        $this->setType(Data::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Product\Subselect\Wishlist')->setValue(null);
        $this->type = 'wishlist';
        $this->wishlistFactory = $wishlistFactory;
    }

    /**
     * @param $customer
     * @return \Magento\Wishlist\Model\ResourceModel\Item\Collection
     */
    public function getValidationCollection($customer)
    {
        $wishlist = $this->wishlistFactory->create()->loadByCustomerId($customer->getId());

        return $wishlist->getItemCollection();
    }
}
