<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Product\Subselect;

use Amasty\Segments\Helper\Condition\Data;
use Amasty\Segments\Model\Rule\Condition\Product\Subselect;
use Amasty\Segments\Model\Rule\Utils\ConditionAttributesFormatter;
use Magento\CatalogRule\Model\Rule\Condition\Product;
use Magento\Reports\Model\ResourceModel\Product\Index\Viewed\Collection;
use Magento\Reports\Model\ResourceModel\Product\Index\Viewed\CollectionFactory;
use Magento\Rule\Model\Condition\Context;

class Viewed extends Subselect
{
    /**
     * @var CollectionFactory
     */
    protected $collectionViewedFactory;

    public function __construct(
        Context $context,
        Product $conditionCatalog,
        ConditionAttributesFormatter $attributesFormatter,
        CollectionFactory $collectionViewedFactory,
        array $data = []
    ) {
        parent::__construct($context, $conditionCatalog, $attributesFormatter, $data);
        $this->setType(Data::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Product\Subselect\Viewed')->setValue(null);
        $this->type = 'viewed';
        $this->collectionViewedFactory = $collectionViewedFactory;
    }

    /**
     * @param $customer
     * @return Collection
     */
    public function getValidationCollection($customer)
    {
        /** @var Collection $collection */
        $collection = $this->collectionViewedFactory->create();
        $collection->setCustomerId($customer->getId());
        $collection->addIndexFilter();

        return $collection;
    }
}
