<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Product;

use Amasty\Segments\Model\Rule\Utils\ConditionAttributesFormatter;
use Amasty\Segments\Helper\Condition\Data as ConditionHelper;
use Magento\CatalogRule\Model\Rule\Condition\Product as CatalogRuleProduct;
use Magento\Rule\Model\Condition\Context;

class Combine extends \Magento\Rule\Model\Condition\Combine
{
    /**
     * @var CatalogRuleProduct
     */
    protected $conditionCatalog;

    /**
     * @var ConditionAttributesFormatter
     */
    private $attributesFormatter;

    public function __construct(
        Context $context,
        CatalogRuleProduct $conditionCatalog,
        ConditionAttributesFormatter $attributesFormatter,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->setType(ConditionHelper::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Product\Combine');
        $this->conditionCatalog = $conditionCatalog;
        $this->attributesFormatter = $attributesFormatter;
    }

    /**
     * Get new child select options
     *
     * @return array
     */
    public function getNewChildSelectOptions(): array
    {
        return array_merge_recursive(
            parent::getNewChildSelectOptions(),
            [
                [
                    'label' => __('Product Attribute'),
                    'value' => $this->attributesFormatter->format(
                        $this->conditionCatalog,
                        ['quote_item_price', 'quote_item_qty', 'quote_item_row_total']
                    )
                ]
            ]
        );
    }
}
