<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition;

use Amasty\Segments\Helper\Condition\Data as ConditionHelper;

class Product extends Condition
{
    public function getNewChildSelectOptions(): array
    {
        return [
            [
                'value' => ConditionHelper::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Product\Subselect\Viewed',
                'label' => __('Viewed Products by Condition'),
            ],
            [
                'value' => ConditionHelper::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Product\Subselect\Wishlist',
                'label' => __('Products in Wishlist by Condition'),
            ]
        ];
    }
}
