<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Order\Subselect;

use Amasty\Segments\Helper\Condition\Data;
use Amasty\Segments\Model\Rule\Condition\Order\Common;
use Amasty\Segments\Model\Rule\Condition\Order\Subselect;
use Amasty\Segments\Model\Rule\Utils\ConditionAttributesFormatter;
use Magento\Framework\Model\AbstractModel;
use Magento\Rule\Model\Condition\AbstractCondition;
use Magento\Rule\Model\Condition\Context;
use Magento\SalesRule\Model\Rule\Condition\Product;

class AverageTotal extends Subselect
{
    public function __construct(
        Context $context,
        Product $conditionProduct,
        Common $conditionCommon,
        ConditionAttributesFormatter $attributesFormatter,
        \Amasty\Segments\Helper\Order\Data $orderHelper,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $conditionProduct,
            $conditionCommon,
            $attributesFormatter,
            $orderHelper,
            $data
        );
        $this->setType(
            Data::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Order\Subselect\AverageTotal'
        )->setValue(null);
    }

    /**
     * @return $this
     */
    public function loadAttributeOptions(): AbstractCondition
    {
        $this->setAttributeOption(['average_order_total' => __('average order total')]);

        return $this;
    }

    /**
     * @param AbstractModel $model
     * @return bool
     */
    public function validate(AbstractModel $model): bool
    {
        $result = false;
        $model = $this->objectValidation($model);
        $orders = $this->orderHelper->getCollectionByCustomerType($model);
        $total = 0;
        $totalAmount = 0;

        if ($orders && $orders->getSize()) {
            foreach ($orders as $item) {
                if (!$this->getConditions() || parent::validate($item)) {
                    $total ++;
                    $totalAmount += $item->getBaseGrandTotal();
                }
            }
            $attr = $total ? round($totalAmount / $total, 2) : 0;
            $result = $this->validateAttribute($attr);
        }

        return $result;
    }

    protected function canValidateGuest(): bool
    {
        return true;
    }
}
