<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Order\Subselect;

use Amasty\Segments\Helper\Condition\Data;
use Amasty\Segments\Helper\Order\Data as OrderHelper;
use Amasty\Segments\Model\Rule\Condition\Order\Common;
use Amasty\Segments\Model\Rule\Condition\Order\Subselect;
use Amasty\Segments\Model\Rule\Utils\ConditionAttributesFormatter;
use Magento\Framework\Model\AbstractModel;
use Magento\Rule\Model\Condition\AbstractCondition;
use Magento\Rule\Model\Condition\Context;
use Magento\SalesRule\Model\Rule\Condition\Product;

class Amount extends Subselect
{
    public function __construct(
        Context $context,
        Product $conditionProduct,
        Common $conditionCommon,
        OrderHelper $orderHelper,
        ConditionAttributesFormatter $attributesFormatter,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $conditionProduct,
            $conditionCommon,
            $attributesFormatter,
            $orderHelper,
            $data
        );
        $this->setType(Data::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Order\Subselect\Amount')->setValue(null);
    }

    /**
     * Load attribute options
     *
     * @return $this
     */
    public function loadAttributeOptions(): AbstractCondition
    {
        $this->setAttributeOption(['base_grand_total' => __('total amount')]);

        return $this;
    }

    /**
     * Validate
     *
     * @param AbstractModel $model
     * @return bool
     */
    public function validate(AbstractModel $model): bool
    {
        $attr = $this->getAttribute();
        $total = 0;
        $model = $this->objectValidation($model);
        $orders = $this->orderHelper->getCollectionByCustomerType($model);

        if ($orders && count($orders)) {
            foreach ($orders as $order) {
                $validItemsTotal = $this->getValidItemsTotal($order);

                if ($validItemsTotal == count($order->getAllVisibleItems())) {
                    $total += $order->getData($attr);
                }
            }

            return $this->validateAttribute($total);
        }

        return false;
    }

    protected function canValidateGuest(): bool
    {
        return true;
    }
}
