<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition;

use Amasty\Segments\Helper\Condition\Data as ConditionHelper;
use Magento\Rule\Model\Condition\Context;

class Combine extends \Magento\Rule\Model\Condition\Combine
{
    /**
     * @var CombineConditionsProvider
     */
    private $combineConditionsProvider;

    public function __construct(
        Context $context,
        CombineConditionsProvider $combineConditionsProvider,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->setType(ConditionHelper::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Combine');
        $this->combineConditionsProvider = $combineConditionsProvider;
    }

    /**
     * @return array
     */
    public function getNewChildSelectOptions(): array
    {
        $conditions = [
            [
                'value' => ConditionHelper::AMASTY_SEGMENTS_PATH_TO_CONDITIONS . 'Combine',
                'label' => __('Conditions Combination'),
            ]
        ];

        foreach ($this->combineConditionsProvider->getAll() as $condition) {
            $conditions[] = $condition;
        }

        return array_merge_recursive(
            parent::getNewChildSelectOptions(),
            $conditions
        );
    }
}
