<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Address;

use Amasty\Segments\Model\Rule\Condition\Address;
use Magento\Framework\Model\AbstractModel;
use Magento\Rule\Model\Condition\AbstractCondition;

class Shipping extends Address
{
    /**
     * @var string
     */
    protected $type = 'shipping';

    /**
     * Load attribute options
     *
     * @return $this
     */
    public function loadAttributeOptions(): AbstractCondition
    {
        $attributes = [
            'postcode' => __('Shipping Zip'),
            'region_id' => __('Shipping State/Province'),
            'city' => __('Shipping City'),
            'country_id' => __('Shipping Country'),
        ];
        $this->setAttributeOption($attributes);

        return $this;
    }

    /**
     * Validate Address Rule Condition
     *
     * @param \Magento\Customer\Model\Customer|\Amasty\Segments\Model\GuestCustomerData $model
     *
     * @return \Magento\Customer\Model\Address|bool
     */
    protected function getAddress($model)
    {
        return $model->getDefaultShippingAddress();
    }
}
