<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model\Rule\Condition\Address;

use Amasty\Segments\Model\Rule\Condition\Address;
use Magento\Framework\Model\AbstractModel;
use Magento\Rule\Model\Condition\AbstractCondition;

class Billing extends Address
{
    /**
     * @var string
     */
    protected $type = 'billing';

    /**
     * Load attribute options
     *
     * @return $this
     */
    public function loadAttributeOptions(): AbstractCondition
    {
        $attributes = [
            'email' => __('Email'),
            'city' => __('Billing City'),
            'region_id' => __('Billing State/Province'),
            'country_id' => __('Billing Country'),
            'postcode' => __('Billing Zip'),
        ];
        $this->setAttributeOption($attributes);

        return $this;
    }

    /**
     * Validate Address Rule Condition
     *
     * @param \Magento\Customer\Model\Customer|\Amasty\Segments\Model\GuestCustomerData $model
     * @return bool
     */
    public function validate(AbstractModel $model): bool
    {
        $customer = $this->objectValidation($model);
        if (!$customer) {
            return false;
        }

        if ('email' == $this->getAttribute()) {
            return $this->validateAttribute($model->getEmail());
        }

        return parent::validate($model);
    }

    /**
     * Validate Address Rule Condition
     *
     * @param \Magento\Customer\Model\Customer|\Amasty\Segments\Model\GuestCustomerData $model
     *
     * @return \Magento\Customer\Model\Address|bool
     */
    protected function getAddress($model)
    {
        return $model->getDefaultBillingAddress();
    }
}
