<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Model\ResourceModel\Customer;

use Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot;

class Collection extends \Amasty\Segments\Model\ResourceModel\AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = 'entity_id';

    /**
     * Resource initialization
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(\Magento\Customer\Model\Customer::class, \Amasty\Segments\Model\ResourceModel\Customer::class);
    }

    /**
     * @return $this
     */
    public function getCommonFilters()
    {
        $this->addFilterToMap('entity_id', 'main_table.entity_id')
            ->addFieldToSelect('entity_id')
            ->addFieldToSelect('email')
            ->addFieldToSelect('created_at')
            ->addFieldToSelect('firstname')
            ->addFieldToSelect('lastname')
            ->addFieldToSelect('group_id')
            ->addFieldToSelect('default_billing')
            ->getSelect()
            ->joinLeft(
                ['address' => $this->getTable('customer_address_entity')],
                'main_table.default_billing = address.entity_id',
                ['address.telephone', 'address.country_id', 'address.region']
            );

        return $this;
    }

    /**
     * @return $this
     */
    public function loadFromIndex()
    {
        $customerIds = $this->indexResource->getIdsFromIndex(
            self::AMASTY_SEGMENTS_INDEX_TABLE_CUSTOMER_FIELD_NAME,
            $this->segmentContainer->getCurrentSegmentId()
        );

        $this->addFieldToFilter(
            self::PRIMARY_FIELD_NAME,
            ['in' => $customerIds]
        );

        return $this;
    }
}
