<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Controller\Adminhtml\Widget;

use Amasty\Segments\Controller\Adminhtml\Segment;
use Amasty\Segments\Block\Adminhtml\Segment\Widget\Chooser\CouponCode;

class Chooser extends Segment
{
    /**
     * Prepare block for chooser
     *
     * @return void
     */
    public function execute()
    {
        $request = $this->getRequest();

        switch ($request->getParam('attribute')) {
            case 'coupon_code':
                $block = $this->_view->getLayout()->createBlock(
                    CouponCode::class,
                    'amasty_segments_widget_chooser_coupon_code',
                    ['data' => ['js_form_object' => $request->getParam('form')]]
                );
                break;
            default:
                $block = null;
        }

        if ($block) {
            $this->getResponse()->setBody($block->toHtml());
        }
    }
}
