<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Controller\Adminhtml\Segment;

class Refresh extends \Amasty\Segments\Controller\Adminhtml\Segment
{
    public function execute()
    {
        if ($segmentId = $this->getRequest()->getParam(self::SEGMENT_PARAM_URL_KEY)) {
            try {

                $model = $this->segmentRepository->get($segmentId);

                if ($model->getSegmentId()) {
                    $this->segmentCustomerIndexer->executeRow($model->getSegmentId());
                }

                $this->messageManager->addSuccessMessage(__('You refresh the Segment.'));

                if ($segmentId != $model->getId()) {
                    throw new \Magento\Framework\Exception\LocalizedException(
                        __('The wrong Segment is specified.')
                    );
                }

                return $this->resultRedirectFactory->create()->setPath(
                    'amastysegments/*/edit',
                    [self::SEGMENT_PARAM_URL_KEY => $segmentId]
                );
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                $id = (int)$this->getRequest()->getParam(self::SEGMENT_PARAM_URL_KEY);

                $resultRedirect = $this->resultRedirectFactory->create();
                if (!empty($id)) {
                    $resultRedirect->setPath('amastysegments/*/edit', [self::SEGMENT_PARAM_URL_KEY => $id]);
                } else {
                    $resultRedirect->setPath('amastysegments/*');
                }

                return $resultRedirect;
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('Something went wrong while refreshing the segment data. Please try again.')
                );

                return $this->resultRedirectFactory->create()->setPath(
                    'amastysegments/*/edit',
                    [self::SEGMENT_PARAM_URL_KEY => $this->getRequest()->getParam(self::SEGMENT_PARAM_URL_KEY)]
                );
            }
        }

        $this->messageManager->addErrorMessage(__('Something went wront. We can\'t find a segment ID.'));

        return $this->resultRedirectFactory->create()->setPath('amastysegments/*/');
    }
}
