<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Controller\Adminhtml\Segment;

use Magento\Framework\Controller\ResultFactory;

class Index extends \Amasty\Segments\Controller\Adminhtml\Segment
{
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu('Amasty_Segments::segments');
        $resultPage->addBreadcrumb(__('Manage Segments'), __('Manage Segments'));
        $resultPage->getConfig()->getTitle()->prepend(__('Manage Segments'));

        return $resultPage;
    }
}
