<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Controller\Adminhtml\Segment;

use Magento\Framework\Controller\ResultFactory;

class Edit extends \Amasty\Segments\Controller\Adminhtml\Segment
{
    public function execute()
    {
        $segmentId = $this->getRequest()->getParam(self::SEGMENT_PARAM_URL_KEY);

        try {
            if ($segmentModel = $this->segmentRepository->get($segmentId)) {
                $this->initCurrentSegment($segmentModel);
            } else {
                $this->messageManager->addErrorMessage(__(sprintf('Segment with ID: %s not found. ', $segmentId)));

                return $this->resultRedirectFactory->create()->setPath('amastysegments/*/');
            }

            /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
            $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
            $resultPage->setActiveMenu('Amasty_Segments::segments');
            $resultPage->addBreadcrumb(__('Manage Segments'), __('Manage Segments'));
            $resultPage->getConfig()->getTitle()->prepend($segmentId ? $segmentModel->getName() : __('New Segment'));

            return $resultPage;
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $this->messageManager->addErrorMessage($e->getMessage());

            return $this->resultRedirectFactory->create()->setPath('amastysegments/*/');
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(
                __('Something went wrong while saving the segment data. Please review the error log.')
            );

            return $this->resultRedirectFactory->create()->setPath('amastysegments/*/');
        }
    }
}
