<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Controller\Adminhtml\Segment;

use Magento\Framework\Controller\Result\Redirect;

class Delete extends \Amasty\Segments\Controller\Adminhtml\Segment
{

    /**
     * @return Redirect
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam(self::SEGMENT_PARAM_URL_KEY);

        if ($id) {
            try {
                $this->segmentRepository->deleteById($id);
                $this->messageManager->addSuccessMessage(__('You deleted the segment.'));

                return $this->resultRedirectFactory->create()->setPath('amastysegments/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('We can\'t delete the segment right now. Please try again.')
                );

                return $this->resultRedirectFactory->create()->setPath(
                    'amastysegments/*/edit',
                    [self::SEGMENT_PARAM_URL_KEY => $id]
                );
            }
        }

        $this->messageManager->addErrorMessage(__('We can\'t find a segment to delete.'));

        return $this->resultRedirectFactory->create()->setPath('amastysegments/*/');
    }
}
