<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Block\Adminhtml\System\Config\Field;

use Amasty\Base\Helper\Module;
use Magento\Backend\Block\Template;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

class RegisteredCustomerAttributes extends Field
{
    /**
     * @var Module
     */
    private $moduleHelper;

    public function __construct(
        Template\Context $context,
        Module $moduleHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->moduleHelper = $moduleHelper;
    }

    public function render(AbstractElement $element)
    {
        $url = "https://amasty.com/customer-attributes-for-magento-2.html"
            . "?utm_source=module&utm_medium=segmentation&utm_content=customer-attributes";

        if ($this->moduleHelper->isOriginMarketplace()) {
            $url = "https://marketplace.magento.com/amasty-module-customer-attributes.html";
        }

        $html = "To get the ability to enable extra customer attributes you will need to install the <a href='"
            . $url . "' target='_blank'>Amasty Customer Attributes module</a>.";

        $element->setComment($html);

        return parent::render($element);
    }
}
