<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Block\Adminhtml\Segment\Edit\Tab;

use Amasty\Segments\Helper\Base;
use Amasty\Segments\Model\SegmentFactory;
use Amasty\Segments\Model\SegmentRepository;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Form\Renderer\Fieldset;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\Rule\Block\Conditions as ConditionsBlock;
use Magento\Rule\Model\Condition\AbstractCondition;
use Magento\Ui\Component\Layout\Tabs\TabInterface;

class Conditions extends Generic implements TabInterface
{
    /**
     * @var Fieldset
     */
    private $rendererFieldset;

    /**
     * @var ConditionsBlock
     */
    private $conditions;

    /**
     * @var Base
     */
    private $helper;

    /**
     * @var SegmentFactory
     */
    private $segmentFactory;

    /**
     * @var SegmentRepository
     */
    private $segmentRepository;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        ConditionsBlock $conditions,
        Fieldset $rendererFieldset,
        Base $helper,
        SegmentFactory $segmentFactory,
        SegmentRepository $segmentRepository,
        array $data = []
    ) {
        $this->rendererFieldset = $rendererFieldset;
        $this->conditions = $conditions;
        $this->helper = $helper;
        $this->segmentFactory = $segmentFactory;
        $this->segmentRepository = $segmentRepository;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Tab class getter
     *
     * @return string
     */
    public function getTabClass(): string
    {
        return '';
    }

    /**
     * Return URL link to Tab content
     *
     * @return string
     */
    public function getTabUrl(): string
    {
        return '';
    }

    /**
     * Tab should be loaded trough Ajax call
     *
     * @return bool
     */
    public function isAjaxLoaded(): bool
    {
        return false;
    }

    /**
     * Return Tab label
     *
     * @return string
     */
    public function getTabLabel(): string
    {
        return (string)__('Conditions');
    }

    /**
     * Return Tab title
     *
     * @return string
     */
    public function getTabTitle(): string
    {
        return (string)__('Conditions');
    }

    /**
     * Can show tab in tabs
     *
     * @return boolean
     */
    public function canShowTab(): bool
    {
        return true;
    }

    /**
     * Tab is hidden
     *
     * @return boolean
     */
    public function isHidden(): bool
    {
        return false;
    }

    /**
     * Prepare form before rendering HTML
     *
     * @return $this
     */
    protected function _prepareForm()
    {
        $formName = 'amastysegments_segment_form';
        $model = $this->segmentRepository->getSegmentFromRegistry()
            ? $this->segmentRepository->getSegmentFromRegistry() : $this->segmentFactory->create();

        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix('segment_');

        $conditionsFieldSetId = $model->getConditionsFieldSetId($formName);

        $renderer = $this->rendererFieldset
            ->setTemplate('Magento_CatalogRule::promo/fieldset.phtml')
            ->setNewChildUrl(
                $this->getUrl(
                    'amastysegments/segment/newConditionHtml/form/' . $conditionsFieldSetId,
                    ['form_namespace' => $formName]
                )
            )
            ->setFieldSetId($conditionsFieldSetId)
            ->setNameInLayout('amasty.segments.rule.fieldset.conditions');

        $fieldset = $form->addFieldset(
            'conditions_fieldset',
            ['legend' => __('Apply the rule only if the following conditions are met (leave blank for all products)')]
        )->setRenderer(
            $renderer
        );

        $fieldset->addField(
            'conditions',
            'text',
            [
                'name' => 'conditions',
                'label' => __('Conditions'),
                'title' => __('Conditions'),
                'required' => true,
                'data-form-part' => $formName
            ]
        )->setRule(
            $model ? $model->getSalesRule() : null
        )->setRenderer(
            $this->conditions
        );

        $fieldset->addField(
            'guest_note',
            'note',
            [
                'name' => 'guest_note',
                'text' => __('<b>*</b> available for guests and registered customers')
            ]
        );

        $form->setValues($model->getData());
        $this->setConditionFormName($model->getSalesRule()->getConditions(), $formName, $conditionsFieldSetId);
        $this
            ->setForm($form)
            ->setNameInLayout('amasty.segments.rule.tab.conditions');

        return parent::_prepareForm();
    }

    /**
     * Handles addition of form name and JS form object to condition and its conditions.
     *
     * @param AbstractCondition $conditions
     * @param string $formName
     * @param string $jsFormName
     * @return void
     */
    private function setConditionFormName(AbstractCondition $conditions, string $formName, string $jsFormName)
    {
        $conditions->setFormName($formName);
        $conditions->setJsFormObject($jsFormName);

        if ($conditions->getConditions() && is_array($conditions->getConditions())) {
            foreach ($conditions->getConditions() as $condition) {
                $this->setConditionFormName($condition, $formName, $jsFormName);
            }
        }
    }
}
