/**
 * Login Attributes List
 */
define([
    'jquery',
    'underscore',
    'uiComponent',
    'Amasty_CustomerLoginAttributes/js/model/login-attributes-model',
    'Amasty_CustomerLoginAttributes/js/model/login-attributes-validator',
    'Magento_Checkout/js/model/payment/additional-validators'
], function ($, _, Component, loginAttributesModel, loginAttributesValidator, checkoutAdditionalValidators) {
    'use strict';

    return Component.extend({
        defaults: {
            modules: {
                // eslint-disable-next-line no-template-curly-in-string
                amCheckoutEmail: '${ $.parentName }'
            },
            selectors: {
                amCheckoutLoginForm: '.amcheckout-form-login'
            }
        },

        initialize: function () {
            this._super();

            loginAttributesValidator.loginAttributesComponent = this;
            checkoutAdditionalValidators.registerValidator(loginAttributesValidator);
            this.on('attribute-update', this.validateAttributesUniqueness.bind(this));
            this.on('save-for-cart', this.saveValuesForCart.bind(this));
            this.on('save-login-form', this.triggerFormSaving.bind(this));
            this.on('elems', this.validateAttributesUniqueness.bind(this, true));

            this.amCheckoutEmail().passwordConfirmation.subscribe(function () {
                if (!this.elems().length || !$(this.selectors.amCheckoutLoginForm).valid()) {
                    return;
                }

                this.saveValuesForCart();
            }.bind(this));

            return this;
        },

        validateAttributesUniqueness: function (isFirstLoad) {
            var attributes = this.elems();

            _.each(attributes, function (element, index) {
                var nextElementIndex,
                    nextElement;

                if (_.isEmpty(element.value())) {
                    return;
                }

                nextElementIndex = index + 1;

                for (nextElementIndex; nextElementIndex < attributes.length; nextElementIndex++) {
                    nextElement = attributes[nextElementIndex];

                    if (nextElement
                        && !_.isEmpty(nextElement.value())
                        && !nextElement.duplicateMark
                        && element.value() === nextElement.value()
                    ) {
                        element.duplicateMark = true;
                        nextElement.duplicateMark = true;
                    }
                }
            });

            _.each(attributes, function (element) {
                element.isDuplicate = !_.isEmpty(element.value()) && !!element.duplicateMark;
                element.duplicateMark = false;

                // skip validation for empty field on first load
                if (isFirstLoad && _.isEmpty(element.value())) {
                    return;
                }

                element.validate();
            });
        },

        saveValuesForCart: function () {
            loginAttributesModel.saveAttributesForCart();
        },

        triggerFormSaving: function () {
            this.amCheckoutEmail().passwordConfirmation.valueHasMutated();
        }
    });
});
