/**
 * Attributes validation model
 */
define([
    'uiRegistry',
    'Magento_Checkout/js/model/quote',
    'mage/storage',
    'Magento_Checkout/js/model/url-builder'
], function (registry, quote, storage, urlBuilder) {
    'use strict';

    var validationUrls = {
        validateValue: urlBuilder.createUrl('/amasty-customer-login-attributes/validate-value', {}),
        saveForCart: urlBuilder.createUrl(
            '/amasty-customer-login-attributes/save-values-for-cart/:cartId',
            {
                cartId: quote.getQuoteId()
            }
        )
    };

    return {
        /**
         * Get attributes array from provider
         * @return {Array}
         */
        getAttributesFromProvider: function () {
            var loginAttributesData = registry.get('checkoutProvider').get('login-attributes');

            return Object.keys(loginAttributesData).map(function (key) {
                return {
                    attribute_code: key,
                    value: loginAttributesData[key]
                };
            });
        },

        /**
         * @param {UIClass} element
         * @param {String} code
         * @param {String} value
         * @returns {void}
         */
        validate: function (element, code, value) {
            var attributeData = {
                attribute_value: {
                    attribute_code: code,
                    value: value
                }
            };

            storage
                .post(
                    validationUrls.validateValue,
                    JSON.stringify(attributeData)
                )
                .success(function () {
                    element.validationResponse = null;
                })
                .fail(function (response) {
                    element.validationResponse = response;
                })
                .always(function () {
                    element.validate();
                    element.bubble('attribute-update');
                });
        },

        /**
         * Save attributes
         * @returns {void}
         */
        saveAttributesForCart: function () {
            var loginAttributesObject = {
                'attribute_values': this.getAttributesFromProvider()
            };

            storage.post(
                validationUrls.saveForCart,
                JSON.stringify(loginAttributesObject)
            );
        }
    };
});
