/**
 * Modify UI Component type login form
 */
define(['jquery', 'uiElement'], function ($, Element) {
    'use strict';

    return Element.extend({
        defaults: {
            emailFieldSelector: '',
            emailLabelSelector: '',
            isReplaceField: false,
            isOverrideLabel: false,
            newFieldLabel: null,
            isOverrideNote: false,
            newNote: null
        },

        initialize: function () {
            this._super();

            $.async(this.emailFieldSelector, this.modifyForm.bind(this));

            return this;
        },

        modifyForm: function () {
            var options = {
                emailFieldSelector: this.emailFieldSelector,
                emailLabelSelector: this.emailLabelSelector,
                isReplaceField: this.isReplaceField,
                isOverrideLabel: this.isOverrideLabel,
                newFieldLabel: this.newFieldLabel,
                isOverrideNote: this.isOverrideNote,
                newNote: this.newNote
            };

            window.amModifyLoginForm(options);
        }
    });
});
