<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\ViewModel;

use Amasty\CustomerLoginAttributes\Model\ConfigProvider;
use Amasty\CustomerLoginAttributes\Model\EnabledValidator;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class LoginViewModel implements ArgumentInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var EnabledValidator
     */
    private $enabledValidator;

    public function __construct(ConfigProvider $configProvider, EnabledValidator $enabledValidator)
    {
        $this->configProvider = $configProvider;
        $this->enabledValidator = $enabledValidator;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabledValidator->isEnabled();
    }

    /**
     * @return bool
     */
    public function isOverrideLoginTitle(): bool
    {
        return $this->configProvider->isNewLoginFieldTitle() && $this->getNewLoginTitle();
    }

    /**
     * @return string
     */
    public function getNewLoginTitle(): string
    {
        return $this->configProvider->getNewLoginFieldTitle();
    }

    /**
     * @return bool
     */
    public function isOverrideLoginNotice(): bool
    {
        return $this->configProvider->isNewLoginNotice() && $this->getNewLoginNotice();
    }

    /**
     * @return string
     */
    public function getNewLoginNotice(): string
    {
        return $this->configProvider->getNewLoginNotice();
    }
}
