<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Ui\DataProvider\LoginAttribute\Form\Modifier;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Magento\Ui\Component\Form\Field;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class StoreLabels implements ModifierInterface
{
    public const STORE_FIELD_PREFIX = 'store_label_';

    /**
     * @var \Magento\Store\Model\System\Store
     */
    private $store;

    public function __construct(\Magento\Store\Model\System\Store $store)
    {
        $this->store = $store;
    }

    /**
     * @param array $data
     * @return array
     */
    public function modifyData(array $data)
    {
        return $data;
    }

    /**
     * @param array $meta
     * @return array
     */
    public function modifyMeta(array $meta)
    {
        $sortOrder = 10;
        foreach ($this->store->getStoreCollection() as $store) {
            $id = $store->getId();
            $meta['store_labels']['children'][self::STORE_FIELD_PREFIX . $id]['arguments']['data']['config'] = [
                'componentType' => Field::NAME,
                'formElement' => 'input',
                'label' => $store->getName(),
                'dataType' => 'text',
                'sortOrder' => $sortOrder,
                'dataScope' => LoginAttributeInterface::STORE_LABELS . '.' . $id,
                'source' => 'attribute',
            ];

            $sortOrder += 10;
        }

        return $meta;
    }
}
