<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Ui\Component\Listing;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;

class LoginAttributesColumns
{
    public const DEFAULT_START_SORT_ORDER = 300;
    public const GRID_ATTRIBUTE_COLUMN_PREFIX = 'am_custlog_';

    /**
     * @var int
     */
    private $startSortOrder;

    /**
     * @var string
     */
    private $columnsPrefix;

    /**
     * @var \Magento\Framework\View\Element\UiComponentFactory
     */
    private $componentFactory;

    public function __construct(
        \Magento\Framework\View\Element\UiComponentFactory $componentFactory,
        int $startSortOrder = self::DEFAULT_START_SORT_ORDER,
        string $columnsPrefix = self::GRID_ATTRIBUTE_COLUMN_PREFIX
    ) {
        $this->startSortOrder = $startSortOrder;
        $this->columnsPrefix = $columnsPrefix;
        $this->componentFactory = $componentFactory;
    }

    /**
     * Add extra columns (Login Attributes' columns) to UI grid
     * @param \Magento\Ui\Component\Listing\Columns $columns
     * @param LoginAttributeInterface[] $attributes
     * @param bool $filterable
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function addLoginAttributesColumns(
        \Magento\Ui\Component\Listing\Columns $columns,
        array $attributes,
        bool $filterable
    ) {
        $columnSortOrder = $this->startSortOrder;
        foreach ($attributes as $attribute) {
            $attributeCode = $this->columnsPrefix . $attribute->getAttributeCode();
            $config = [
                'label' => $attribute->getLabel(),
                'dataType' => 'text',
                'sortOrder' => $columnSortOrder,
                'add_field' => false,
                'visible' => true,
                'sortable' => true,
                'filter' => 'text',
                'component' => 'Magento_Ui/js/grid/columns/column'
            ];

            if (!$filterable) {
                unset($config['filter']);
            }

            $arguments = [
                'data' => [
                    'config' => $config,
                ],
                'context' => $columns->getContext(),
            ];
            $column = $this->componentFactory->create($attributeCode, 'column', $arguments);
            $column->prepare();
            $columns->addComponent($attributeCode, $column);

            $columnSortOrder += 10;
        }
    }
}
