<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Ui\Component\Form\Field;

use Amasty\Base\Model\Feed\ExtensionsProvider;
use Magento\Framework\Module\Manager;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Form\Field;

class OSCToggle extends Field
{
    private const URL_PLACEHOLDER = '{{oscUrl}}';
    private const SEO_PARAMS = 'utm_source=extension&utm_medium=backend&utm_campaign=feature_loginOSC';

    /**
     * @var Manager
     */
    private $moduleManager;

    /**
     * @var ExtensionsProvider
     */
    private $extensionsProvider;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        Manager $moduleManager,
        ExtensionsProvider $extensionsProvider,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->moduleManager = $moduleManager;
        $this->extensionsProvider = $extensionsProvider;
    }

    /**
     * Prepare component configuration
     *
     * @return void
     */
    public function prepare(): void
    {
        parent::prepare();
        if ($this->moduleManager->isEnabled('Amasty_Checkout')) {
            $this->_data['config']['disabled'] = true;
        }

        $this->_data = $this->enableComponent($this->_data);
        $this->_data = $this->addUrlToAdditionalInfo($this->_data);
    }

    /**
     * @param array $config
     * @return array
     */
    private function enableComponent(array $config): array
    {
        if ($this->moduleManager->isEnabled('Amasty_Checkout')) {
            $config['config']['disabled'] = false;
        }

        return $config;
    }

    /**
     * @param array $config
     * @return array
     */
    private function addUrlToAdditionalInfo(array $config): array
    {
        $additionalInfo = $config['config']['additionalInfo'] ?? '';
        if ($additionalInfo) {
            $additionalInfo = str_replace(
                self::URL_PLACEHOLDER,
                $this->getAmastyOSCUrl(),
                $additionalInfo
            );
            $additionalInfo = '<small>' . $additionalInfo . '</small>';
            $config['config']['additionalInfo'] = $additionalInfo;
        }

        return $config;
    }

    /**
     * @return string
     */
    private function getAmastyOSCUrl(): string
    {
        $checkoutModuleData = $this->extensionsProvider->getFeedModuleData('Amasty_Checkout');
        $url = $checkoutModuleData['url'] ?? '';

        if ($url) {
            $urlParts = explode('?', $url);
            if (!empty($urlParts[1])) {
                $urlParts[1] .= '&'  . self::SEO_PARAMS;
            } else {
                $urlParts[1] = self::SEO_PARAMS;
            }

            $url = implode('?', $urlParts);
        }

        return $url;
    }
}
