<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Test\Unit\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\PhoneFormatter;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\PhoneBulkValidator;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\PhoneValidator;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\Collection;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory as AttributeCollectionFactory;
use Magento\Framework\Validator\Exception as ValidatorException;

class PhoneBulkValidatorTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var Collection|\PHPUnit\Framework\MockObject\MockObject
     */
    private $collectionMock;

    /**
     * @var PhoneFormatter|\PHPUnit\Framework\MockObject\MockObject
     */
    private $phoneValidator;

    /**
     * @var PhoneBulkValidator
     */
    private $model;

    public function setUp(): void
    {
        $this->collectionMock = $this->createMock(Collection::class);
        $collectionFactoryMock = $this->createMock(AttributeCollectionFactory:: class);
        $collectionFactoryMock->method('create')->willReturn($this->collectionMock);
        $this->phoneValidator = $this->createMock(PhoneValidator::class);

        $this->model = new PhoneBulkValidator($collectionFactoryMock, $this->phoneValidator);
    }

    /**
     * @covers PhoneBulkValidator::validate()
     */
    public function testValidateException(): void
    {
        $this->expectException(ValidatorException::class);

        $attribute = $this->createMock(LoginAttributeInterface::class);
        $attribute->method('getAttributeCode')->willReturn('telephone');
        $this->collectionMock->method('getItems')->willReturn([$attribute]);
        $this->phoneValidator->method('isValid')->willReturn(false);

        $this->model->validate(['telephone' => '123456']);
    }

    /**
     * @covers PhoneBulkValidator::validate()
     */
    public function testValidateSuccess(): void
    {
        $attribute = $this->createMock(LoginAttributeInterface::class);
        $attribute->method('getAttributeCode')->willReturn('telephone');
        $this->collectionMock->method('getItems')->willReturn([$attribute]);
        $this->phoneValidator->method('isValid')->willReturn(true);

        $this->model->validate(['telephone' => '123456']);
        $this->model->validate([
            'another_attribute' => 'value',
            'telephone' => '123456'
        ]);
    }

    /**
     * @covers PhoneBulkValidator::validate()
     */
    public function testValidateSuccessWithNoAttributes(): void
    {
        $this->collectionMock->method('getItems')->willReturn([]);
        $this->phoneValidator
            ->expects(self::never())
            ->method('isValid')
            ->willReturn(false);

        $this->model->validate([
            'another_attribute' => 'value',
            'telephone' => '123456'
        ]);
    }
}
