<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Test\Unit\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\LocalUniqueBulkValidator;
use Magento\Framework\Validator\Exception as ValidatorException;

class LocalUniqueBulkValidatorTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var LocalUniqueBulkValidator
     */
    private $model;

    protected function setUp(): void
    {
        $this->model = new LocalUniqueBulkValidator();
    }

    /**
     * @covers LocalUniqueBulkValidator::validate()
     */
    public function testValidateException(): void
    {
        $this->expectException(ValidatorException::class);
        $this->model->validate([
            'attr1' => 'val1',
            'attr2' => 'val2',
            'attr3' => 'val3',
            'attr4' => '',
            'attr5' => '',
            'attr6' => 'val1',
        ]);
    }

    /**
     * @covers LocalUniqueBulkValidator::validate()
     */
    public function testValidateSuccess(): void
    {
        $this->model->validate([
            'attr1' => 'val1',
            'attr2' => 'val2',
            'attr3' => 'val3',
            'attr4' => '',
            'attr5' => '',
        ]);
    }
}
