<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Test\Unit\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeCustomerValueInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\DbUniqueBulkValidator;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue\Collection;
use \Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue\CollectionFactory;
use Magento\Framework\Validator\Exception as ValidatorException;

class DbUniqueBulkValidatorTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var Collection|\PHPUnit\Framework\MockObject\MockObject
     */
    private $collectionMock;

    /**
     * @var DbUniqueBulkValidator
     */
    private $model;

    public function setUp(): void
    {
        $this->collectionMock = $this->createMock(Collection::class);

        $collectionFactory = $this->createMock(CollectionFactory::class);
        $collectionFactory->method('create')->willReturn($this->collectionMock);

        $this->model = new DbUniqueBulkValidator($collectionFactory);
    }

    /**
     * @covers DbUniqueBulkValidator::validate()
     */
    public function testValidateException(): void
    {
        $valueModel = $this->createMock(LoginAttributeCustomerValueInterface::class);
        $valueModel->method('getValue')->willReturn('val2');

        $this->collectionMock->method('getItems')->willReturn([$valueModel]);

        $this->expectException(ValidatorException::class);
        $this->model->validate([
            'attr1' => 'val1',
            'attr2' => 'val2',
            'attr3' => 'val3',
            'attr4' => '',
            'attr5' => '',
            'attr6' => 'val1',
        ]);
    }

    /**
     * @covers DbUniqueBulkValidator::validate()
     */
    public function testValidateSuccess(): void
    {
        $this->collectionMock->method('getItems')->willReturn([]);
        $this->model->validate([
            'attr1' => 'val1',
            'attr2' => 'val2',
            'attr3' => 'val3',
            'attr4' => '',
            'attr5' => '',
        ]);
    }
}
