<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Test\Unit\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Amasty\CustomerLoginAttributes\Api\ValueGetListInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\UnchangedValuesFilter;

class UnchangedValuesFilterTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var ValueGetListInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    private $valueGetListMock;

    /**
     * @var UnchangedValuesFilter
     */
    private $model;

    public function setUp(): void
    {
        $this->valueGetListMock = $this->createMock(ValueGetListInterface::class);

        $this->model = new UnchangedValuesFilter($this->valueGetListMock);
    }

    /**
     * @param array $loginAttributesData
     * @param array $existLoginAttributesData
     * @param array $expectedResult
     * @covers \Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\UnchangedValuesFilter::filter
     * @dataProvider dataProvider
     */
    public function testFilter(
        array $loginAttributesData,
        array $existLoginAttributesData,
        array $expectedResult
    ): void {
        $existLoginAttributes = [];
        foreach ($existLoginAttributesData as $attributeCode => $attributeValue) {
            $exist = $this->createMock(ValueDataInterface::class);
            $exist->method('getAttributeCode')->willReturn($attributeCode);
            $exist->method('getValue')->willReturn($attributeValue);
            $existLoginAttributes[] = $exist;
        }

        $this->valueGetListMock->method('getByCustomerId')->willReturn($existLoginAttributes);

        $result = $this->model->filter(1, $loginAttributesData);

        $this->assertSame($expectedResult, $result);
    }

    public function dataProvider(): array
    {
        return [
            'empty' => [
                'loginAttributesData' => [],
                'existLoginAttributesData' => [],
                'expectedResult' => []
            ],
            'emptyExists' => [
                'loginAttributesData' => [
                    'attr1' => 'val1',
                    'attr2' => 'val2',
                    'attr3' => 'val3',
                ],
                'existLoginAttributesData' => [],
                'expectedResult' => [
                    'attr1' => 'val1',
                    'attr2' => 'val2',
                    'attr3' => 'val3',
                ]
            ],
            'reducedArray' => [
                'loginAttributesData' => [
                    'attr1' => 'val1',
                    'attr2' => 'val2',
                    'attr3' => 'val3',
                ],
                'existLoginAttributesData' => [
                    'attr1' => 'val1',
                ],
                'expectedResult' => [
                    'attr2' => 'val2',
                    'attr3' => 'val3',
                ]
            ],
            'changedExists' => [
                'loginAttributesData' => [
                    'attr1' => 'val1',
                    'attr2' => 'val2',
                    'attr3' => 'val3',
                ],
                'existLoginAttributesData' => [
                    'attr1' => 'oldVal1',
                ],
                'expectedResult' => [
                    'attr1' => 'val1',
                    'attr2' => 'val2',
                    'attr3' => 'val3',
                ]
            ]
        ];
    }
}
