<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Test\Unit\Model\LoginAttributeCustomerValue\Formatter;

use Amasty\CustomerLoginAttributes\Model\ConfigProvider;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\CountryResolver;
use Amasty\CustomerLoginAttributes\Model\Wrapper\GeoipWrapper;

class CountryResolverTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @param bool $isUseGeoip
     * @param string|null $geoipCountry
     * @param string|null $country
     * @param string|null $expectedResult
     * @covers \Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\CountryResolver::getCountry
     * @dataProvider dataProvider
     */
    public function testGetCountry(
        bool $isUseGeoip,
        ?string $geoipCountry,
        ?string $country,
        ?string $expectedResult
    ): void {
        $configProvider = $this->createMock(ConfigProvider::class);
        $configProvider->method('isUseGeoipForPhoneCountry')->willReturn($isUseGeoip);
        $configProvider->method('getDefaultPhoneCountry')->willReturn($country);

        $geoipWrapper = $this->createMock(GeoipWrapper::class);
        $geoipWrapper->method('getCountry')->willReturn($geoipCountry);

        $model = new CountryResolver($configProvider, $geoipWrapper);

        $this->assertSame($expectedResult, $model->getCountry());
    }

    /**
     * @return array
     */
    public function dataProvider(): array
    {
        return [
            'geoipDisabled' => [
                'isUseGeoip' => false,
                'geoipCountry' => '',
                'country' => 'US',
                'expectedResult' => 'US',
            ],
            'geoipDisabledConfigEmpty' => [
                'isUseGeoip' => false,
                'geoipCountry' => '',
                'country' => null,
                'expectedResult' => null,
            ],
            'geoipEnabledAndEmpty' => [
                'isUseGeoip' => true,
                'geoipCountry' => '',
                'country' => 'US',
                'expectedResult' => 'US',
            ],
            'geoipEnabled' => [
                'isUseGeoip' => true,
                'geoipCountry' => 'AU',
                'country' => 'US',
                'expectedResult' => 'AU',
            ],
        ];
    }
}
