<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Test\Unit\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttribute\LabelProvider;

class LabelProviderTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @param array $storeLabels
     * @param string $defaultLabel
     * @param int $storeId
     * @param string $expectedResult
     * @dataProvider dataProvider
     * @covers LabelProvider::getLabelForStore()
     */
    public function testGetLabelForStore(
        array $storeLabels,
        string $defaultLabel,
        int $storeId,
        string $expectedResult
    ): void {
        $loginAttributeMock = $this->createMock(LoginAttributeInterface::class);
        $loginAttributeMock->method('getStoreLabels')->willReturn($storeLabels);
        $loginAttributeMock->method('getLabel')->willReturn($defaultLabel);

        $model = new LabelProvider();
        $result = $model->getLabelForStore($loginAttributeMock, $storeId);

        $this->assertSame($expectedResult, $result);
    }

    /**
     * @return array[]
     */
    public function dataProvider(): array
    {
        return [
            'defaultLabel' => [
                'storeLabels' => [3 => 'Never Label'],
                'defaultLabel' => 'Default',
                'storeId' => 1,
                'expectedResult' => 'Default'
            ],
            'storeLabel' => [
                'storeLabels' => [3 => 'Store Label'],
                'defaultLabel' => 'Default',
                'storeId' => 3,
                'expectedResult' => 'Store Label'
            ],
            'emptyStoreLabel' => [
                'storeLabels' => [3 => 'Store Label', 0 => ''],
                'defaultLabel' => 'Default',
                'storeId' => 0,
                'expectedResult' => 'Default'
            ],
        ];
    }
}
