<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\SocialLogin\Block;

use Amasty\CustomerLoginAttributes\Model\ConfigProvider;
use Amasty\SocialLogin\Block\Popup;
use Magento\Framework\Serialize\Serializer\Json;

class ChangePlaceholderInPopup
{
    /**
     * @var Json
     */
    private $jsonSerializer;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        Json $jsonSerializer,
        ConfigProvider $configProvider
    ) {
        $this->jsonSerializer = $jsonSerializer;
        $this->configProvider = $configProvider;
    }

    /**
     * Change field label in Amasty social login popup
     *
     * @param Popup $subject
     * @param string $result
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetJsonConfig(
        Popup $subject,
        string $result
    ): string {
        if (!$this->configProvider->isNewLoginFieldTitle()) {
            return $result;
        }
        $data = $this->jsonSerializer->unserialize($result);
        $data['textValues']['emailFieldLabel'] = $this->configProvider->getNewLoginFieldTitle();

        return $this->jsonSerializer->serialize($data);
    }
}
