<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\SaveCustomer\Customer\Model\Metadata;

use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\BulkPhoneFormatter;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\UnchangedValuesFilter;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\BulkValidatorInterface;
use Amasty\CustomerLoginAttributes\Plugin\AdminOutput\Customer\Ui\Component\Form\AddLoginAttributesToCustomerFormPlugin;
use Magento\Customer\Model\Metadata\Form;
use Magento\Framework\App\RequestInterface;

class ValidateCustomerFormPlugin
{
    /**
     * @var BulkValidatorInterface
     */
    private $bulkValidator;

    /**
     * @var UnchangedValuesFilter
     */
    private $unchangedValuesFilter;

    /**
     * @var BulkPhoneFormatter
     */
    private $bulkPhoneFormatter;

    public function __construct(
        BulkValidatorInterface $bulkValidator,
        UnchangedValuesFilter $unchangedValuesFilter,
        BulkPhoneFormatter $bulkPhoneFormatter
    ) {
        $this->bulkValidator = $bulkValidator;
        $this->unchangedValuesFilter = $unchangedValuesFilter;
        $this->bulkPhoneFormatter = $bulkPhoneFormatter;
    }

    /**
     * Validate all customer login attributes
     *
     * @param Form $subject
     * @param RequestInterface $request
     * @param null|string $scope
     * @param bool $scopeOnly
     * @throws \Magento\Framework\Validator\Exception
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExtractData(
        Form $subject,
        RequestInterface $request,
        $scope = null,
        $scopeOnly = true
    ): void {
        $customerData = $request->getPostValue($scope);
        $loginAttributesData = $customerData[AddLoginAttributesToCustomerFormPlugin::FIELD_AREA] ?? [];
        $customerId = (int)$request->getParam('customer_id');

        $loginAttributesData = $this->bulkPhoneFormatter->format($loginAttributesData);
        if ($customerId) {
            $loginAttributesData = $this->unchangedValuesFilter->filter($customerId, $loginAttributesData);
        }

        $this->bulkValidator->validate($loginAttributesData);
    }
}
