<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\SaveCustomer\Checkout\Model;

use Amasty\CustomerLoginAttributes\Api\ValidateValueInterface;
use Amasty\CustomerLoginAttributes\Model\QuoteValue\GetValuesForQuote;
use Magento\Checkout\Api\GuestPaymentInformationManagementInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Api\Data\AddressInterface;
use Magento\Quote\Api\Data\PaymentInterface;
use Magento\Quote\Model\MaskedQuoteIdToQuoteIdInterface;

/**
 * Plugin for validate login attribute values before place order
 */
class ValidateGuestPlaceOrderPlugin
{
    /**
     * @var ValidateValueInterface
     */
    private $validateValue;

    /**
     * @var GetValuesForQuote
     */
    private $getValuesForQuote;

    /**
     * @var MaskedQuoteIdToQuoteIdInterface
     */
    private $maskedQuoteIdToQuoteId;

    public function __construct(
        ValidateValueInterface $validateValue,
        GetValuesForQuote $getValuesForQuote,
        MaskedQuoteIdToQuoteIdInterface $maskedQuoteIdToQuoteId
    ) {
        $this->validateValue = $validateValue;
        $this->getValuesForQuote = $getValuesForQuote;
        $this->maskedQuoteIdToQuoteId = $maskedQuoteIdToQuoteId;
    }

    /**
     *
     * @param GuestPaymentInformationManagementInterface $subject
     * @param string $cartId
     * @param string $email
     * @param PaymentInterface $paymentMethod
     * @param AddressInterface|null $billingAddress
     * @throws \Magento\Framework\Validator\Exception
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeSavePaymentInformationAndPlaceOrder(
        GuestPaymentInformationManagementInterface $subject,
        $cartId,
        $email,
        PaymentInterface $paymentMethod,
        AddressInterface $billingAddress = null
    ): void {

        try {
            $quoteId = $this->maskedQuoteIdToQuoteId->execute($cartId);
        } catch (NoSuchEntityException $e) {
            return;
        }

        $attributeValues = $this->getValuesForQuote->get($quoteId);
        if ($attributeValues) {
            $this->validateValue->bulkValidate($attributeValues);
        }
    }
}
