<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\SaveCustomer\Checkout\Model;

use Amasty\CheckoutCore\Api\AccountManagementInterface;
use Amasty\CustomerLoginAttributes\Api\ValueBulkSaveInterface;
use Amasty\CustomerLoginAttributes\Model\QuoteValue\GetValuesForQuote;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 * Plugin for saving customer login attributes' values after registration on checkout
 */
class SaveAfterCreateAccountFromOrder
{
    /**
     * @var ValueBulkSaveInterface
     */
    private $valueBulkSave;

    /**
     * @var GetValuesForQuote
     */
    private $getValuesForQuote;

    public function __construct(
        ValueBulkSaveInterface $valueBulkSave,
        GetValuesForQuote $getValuesForQuote
    ) {
        $this->valueBulkSave = $valueBulkSave;
        $this->getValuesForQuote = $getValuesForQuote;
    }

    /**
     * @param AccountManagementInterface $subject
     * @param bool|CustomerInterface $result
     * @param OrderInterface $order
     * @return bool|CustomerInterface
     * @throws \Magento\Framework\Validator\Exception
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterCreateAccount(
        AccountManagementInterface $subject,
        $result,
        OrderInterface $order
    ) {
        if (!($result instanceof CustomerInterface)) {
            return $result;
        }
        $quoteId = (int)$order->getQuoteId();

        $attributeValues = $this->getValuesForQuote->get($quoteId);
        if ($attributeValues) {
            $this->valueBulkSave->save(
                (int)$result->getId(),
                $attributeValues
            );
        }

        return $result;
    }
}
