<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\Authentication\Customer\AccountManagement;

use Amasty\CustomerLoginAttributes\Model\EnabledValidator;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\FindEmailService;
use Magento\Customer\Api\AccountManagementInterface;
use Magento\Store\Model\StoreManagerInterface;

class AddLoginAttributesAsAuthPlugin
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var FindEmailService
     */
    private $findEmailService;

    /**
     * @var EnabledValidator
     */
    private $enabledValidator;

    public function __construct(
        StoreManagerInterface $storeManager,
        FindEmailService $findEmailService,
        EnabledValidator $enabledValidator
    ) {
        $this->storeManager = $storeManager;
        $this->findEmailService = $findEmailService;
        $this->enabledValidator = $enabledValidator;
    }

    /**
     * @param AccountManagementInterface $subject
     * @param string $email
     * @param string $password
     * @return array
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeAuthenticate(AccountManagementInterface $subject, $email, $password): array
    {
        if ($this->enabledValidator->isEnabled()) {
            $possibleEmail = $this->findEmailService->findByValue(
                $email,
                (int)$this->storeManager->getStore()->getId()
            );

            // if we found an email, or no email found but email login disabled
            if ($possibleEmail || !$this->enabledValidator->isEmailLoginEnabled()) {
                $email = (string)$possibleEmail;
            }
        }

        return [$email, $password];
    }
}
