<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\AdminOutput\Order\Ui\Component\Listing;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;
use Amasty\CustomerLoginAttributes\Ui\Component\Listing\LoginAttributesColumns;
use Magento\Ui\Component\Listing\Columns;

class AddLoginAttributeColumnsPlugin
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var LoginAttributesColumns
     */
    private $loginAttributesColumns;

    public function __construct(
        CollectionFactory $collectionFactory,
        LoginAttributesColumns $loginAttributesColumns
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->loginAttributesColumns = $loginAttributesColumns;
    }

    /**
     * Add Login Attributes' columns to order grid
     * @param Columns $subject
     * @param void $result
     * @return void
     */
    public function afterPrepare(Columns $subject, $result)
    {
        if ($this->allowToAddAttributes($subject)) {
            $collection = $this->collectionFactory->create();
            $collection->addFieldToFilter(LoginAttributeInterface::IS_SHOW_ON_ORDER_GRID, 1);
            $this->loginAttributesColumns->addLoginAttributesColumns($subject, $collection->getItems(), false);
        }
        
        return $result;
    }

    /**
     * Is can add Customer Login Attributes' Columns to Component
     *
     * @param Columns $columnsComponent
     *
     * @return bool
     */
    public function allowToAddAttributes(Columns $columnsComponent): bool
    {
        return $columnsComponent->getName() === 'sales_order_columns';
    }
}
