<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\AdminOutput\CustomerAttributes\Block\Adminhtml\Customer\Attribute;

use Amasty\CustomerAttributes\Block\Adminhtml\Customer\Attribute;
use Magento\Framework\View\LayoutInterface;

class AddLoginAttributesLink
{
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;

    public function __construct(\Magento\Framework\UrlInterface $urlBuilder)
    {
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @param Attribute $subject
     * @param LayoutInterface $layout
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeSetLayout(Attribute $subject, LayoutInterface $layout): void
    {
        $url = $this->urlBuilder->getUrl('amcustomerloginattr/attribute/index');
        $subject->addButton(
            'login_attributes',
            [
                'label' => __('Login Attributes'),
                'onclick' => 'setLocation(\'' . $url . '\')',
                'class' => ''
            ]
        );
    }
}
