<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\AdminOutput\Customer\Ui\Component\Listing;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;
use Amasty\CustomerLoginAttributes\Ui\Component\Listing\LoginAttributesColumns;
use Magento\Customer\Ui\Component\DataProvider;
use Magento\Framework\Api\Search\SearchCriteria;
use Magento\Framework\Api\Search\SearchResultInterface;

class AddLoginAttributesDataPlugin
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var string
     */
    private $columnPrefix;

    public function __construct(
        CollectionFactory $collectionFactory,
        string $columnPrefix = LoginAttributesColumns::GRID_ATTRIBUTE_COLUMN_PREFIX
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->columnPrefix = $columnPrefix;
    }

    /**
     * Modify search criteria for filters working
     * @param DataProvider $subject
     * @param SearchCriteria $searchCriteria
     * @return SearchCriteria
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetSearchCriteria(DataProvider $subject, SearchCriteria $searchCriteria): SearchCriteria
    {
        foreach ($searchCriteria->getFilterGroups() as $filterGroup) {
            foreach ($filterGroup->getFilters() as $filter) {
                if (strpos($filter->getField(), $this->columnPrefix) === 0) {
                    $filter->setField($filter->getField() . '.value');
                }
            }
        }
        return $searchCriteria;
    }

    /**
     * Add data to collection
     * @param DataProvider $subject
     * @param SearchResultInterface $collection
     * @return SearchResultInterface
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetSearchResult(
        DataProvider $subject,
        SearchResultInterface $collection
    ): SearchResultInterface {
        $attributesCollection = $this->collectionFactory->create();
        $attributesCollection->addFieldToFilter(LoginAttributeInterface::IS_SHOW_ON_CUSTOMER_GRID, 1);

        $attributeValuesTable = $attributesCollection->getTable('amasty_customer_login_attribute_customer_value');
        /** @var LoginAttributeInterface $attribute */
        foreach ($attributesCollection->getItems() as $attribute) {
            $alias = $this->columnPrefix . $attribute->getAttributeCode();
            $collection->getSelect()
                ->joinLeft(
                    [$alias => $attributeValuesTable],
                    "{$alias}.customer_id = main_table.entity_id AND {$alias}.attribute_id = "
                        . $attribute->getAttributeId(),
                    [$alias => $alias . '.value']
                );
        }

        return $collection;
    }
}
