<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Plugin\AdminOutput\Customer\Ui\Component\Listing;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;
use Amasty\CustomerLoginAttributes\Ui\Component\Listing\LoginAttributesColumns;
use Magento\Customer\Ui\Component\Listing\Columns;

class AddLoginAttributeColumnsPlugin
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var LoginAttributesColumns
     */
    private $loginAttributesColumns;

    public function __construct(
        CollectionFactory $collectionFactory,
        LoginAttributesColumns $loginAttributesColumns
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->loginAttributesColumns = $loginAttributesColumns;
    }

    /**
     * @param Columns $subject
     * @param void $result
     * @return void
     */
    public function afterPrepare(Columns $subject, $result)
    {
        $collection = $this->collectionFactory->create();
        $collection->addFieldToFilter(LoginAttributeInterface::IS_SHOW_ON_CUSTOMER_GRID, 1);

        $this->loginAttributesColumns->addLoginAttributesColumns($subject, $collection->getItems(), true);

        return $result;
    }
}
