<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Observer\Frontend;

use Amasty\CustomerLoginAttributes\Api\ValueBulkSaveInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Converter\ArrayToObjectsConverter;
use Amasty\CustomerLoginAttributes\Plugin\AdminOutput\Customer\Ui\Component\Form\AddLoginAttributesToCustomerFormPlugin;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Event\ObserverInterface;

class CustomerAttributesSaveObserver implements ObserverInterface
{
    /**
     * @var CustomerRepositoryInterface
     */
    private $customerRepository;

    /**
     * @var ValueBulkSaveInterface
     */
    private $valueBulkSave;

    /**
     * @var ArrayToObjectsConverter
     */
    private $arrayToObjectsConverter;

    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(
        CustomerRepositoryInterface $customerRepository,
        ValueBulkSaveInterface $valueBulkSave,
        ArrayToObjectsConverter $arrayToObjectsConverter,
        RequestInterface $request
    ) {
        $this->customerRepository = $customerRepository;
        $this->valueBulkSave = $valueBulkSave;
        $this->arrayToObjectsConverter = $arrayToObjectsConverter;
        $this->request = $request;
    }

    /**
     * Save customer login attributes values
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $customer = $observer->getData('customer');
        $customerId = (int)$customer->getId();
        $data = $this->request->getPostValue();
        $attributesData = $data[AddLoginAttributesToCustomerFormPlugin::FIELD_AREA] ?? [];

        if ($attributesData) {
            try {
                $attributesData = $this->arrayToObjectsConverter->convert($attributesData);
                $this->valueBulkSave->save($customerId, $attributesData);
            } catch (\Exception $e) {
                // delete customer if something went wrong after registration
                $this->customerRepository->deleteById($customerId);

                throw $e;
            }
        }
    }
}
