<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Observer\Adminhtml;

use Amasty\CustomerLoginAttributes\Api\ValueBulkSaveInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Converter\ArrayToObjectsConverter;
use Amasty\CustomerLoginAttributes\Plugin\AdminOutput\Customer\Ui\Component\Form\AddLoginAttributesToCustomerFormPlugin;
use Magento\Framework\Event\ObserverInterface;

class CustomerAttributesSaveObserver implements ObserverInterface
{

    /**
     * @var ValueBulkSaveInterface
     */
    private $valueBulkSave;

    /**
     * @var ArrayToObjectsConverter
     */
    private $arrayToObjectsConverter;

    public function __construct(
        ValueBulkSaveInterface $valueBulkSave,
        ArrayToObjectsConverter $arrayToObjectsConverter
    ) {
        $this->valueBulkSave = $valueBulkSave;
        $this->arrayToObjectsConverter = $arrayToObjectsConverter;
    }

    /**
     * Save customer login attributes values
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $customer = $observer->getData('customer');
        $request = $observer->getData('request');
        if ($request->getFullActionName() == 'customer_index_save') {
            $customerId = (int)$customer->getId();
            $data = $request->getPost('customer');
            $attributesData = $data[AddLoginAttributesToCustomerFormPlugin::FIELD_AREA] ?? [];

            if ($attributesData) {
                $attributesData = $this->arrayToObjectsConverter->convert($attributesData);
                $this->valueBulkSave->save($customerId, $attributesData);
            }
        }
    }
}
