<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\Wrapper;

use Amasty\Geoip\Model\Geolocation;
use Magento\Framework\HTTP\PhpEnvironment\RemoteAddress;

class GeoipWrapper
{
    /**
     * @var Geolocation
     */
    private $geolocation;

    /**
     * @var RemoteAddress
     */
    private $remoteAddress;

    public function __construct(
        Geolocation $geolocation,
        RemoteAddress $remoteAddress
    ) {
        $this->geolocation = $geolocation;
        $this->remoteAddress = $remoteAddress;
    }

    /**
     * @return string|null
     */
    public function getCountry(): ?string
    {
        try {
            $geolocationData = $this->geolocation->locate($this->remoteAddress->getRemoteAddress());
            if ($geolocationData->getData('country')) {
                return $geolocationData->getData('country');
            }
        } catch (\Exception $e) {
            return null;
        }

        return null;
    }
}
