<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\Source\Option;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Store\Model\Store;

class StoreOptions implements OptionSourceInterface
{
    /**
     * All Store Views value
     */
    public const ALL_STORE_VIEWS = Store::DEFAULT_STORE_ID;

    /**
     * @var \Magento\Store\Ui\Component\Listing\Column\Store\Options
     */
    private $storeOptions;

    public function __construct(\Magento\Store\Ui\Component\Listing\Column\Store\Options $storeOptions)
    {
        $this->storeOptions = $storeOptions;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray(): array
    {
        $options = [
            ['value' => self::ALL_STORE_VIEWS, 'label' => __('All Store Views')]
        ];

        $options = array_merge($options, $this->storeOptions->toOptionArray());

        return $options;
    }
}
