<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\Source\Option;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Data\OptionSourceInterface;

class LoginAttributes implements OptionSourceInterface
{
    public const EMAIL = 'email';

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return array[]
     */
    public function toOptionArray(): array
    {
        $options = [
            ['label' => __('Magento Default (email)'), 'value' => self::EMAIL]
        ];

        $collection = $this->collectionFactory->create();
        $collection->setOrder(LoginAttributeInterface::LABEL, AbstractDb::SORT_ORDER_ASC);
        /** @var LoginAttributeInterface $attribute */
        foreach ($collection->getItems() as $attribute) {
            $options[] = [
                'label' => $attribute->getLabel() . ' ('.$attribute->getAttributeCode().')',
                'value' => $attribute->getAttributeCode()
            ];
        }

        return $options;
    }
}
