<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\Source\Option;

use Magento\Framework\Data\OptionSourceInterface;

class InputValidation implements OptionSourceInterface
{
    private const VALUES_FOR_REMOVE = [
        'validate-email',
        'validate-url'
    ];

    /**
     * @var \Magento\Eav\Helper\Data
     */
    private $eavHelperData;

    /**
     * @var array
     */
    private $valuesForRemove;

    public function __construct(
        \Magento\Eav\Helper\Data $eavHelperData,
        array $valuesForRemove = self::VALUES_FOR_REMOVE
    ) {
        $this->eavHelperData = $eavHelperData;
        $this->valuesForRemove = $valuesForRemove;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $values = $this->eavHelperData->getFrontendClasses(null);

        foreach ($values as $key => $valueData) {
            if (in_array($valueData['value'], $this->valuesForRemove)) {
                unset($values[$key]);
            }
        }

        return $values;
    }
}
