<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\Source\Option;

use Magento\Framework\Data\OptionSourceInterface;

class AttributeTypeSource implements OptionSourceInterface
{
    public const TYPE_TEXT = 'text';
    public const TYPE_PHONE = 'phone';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['label' => __('Text Field'), 'value' => self::TYPE_TEXT],
            ['label' => __('Phone Number'), 'value' => self::TYPE_PHONE],
        ];
    }
}
