<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\ResourceModel\QuoteValue;

use Amasty\CustomerLoginAttributes\Model\QuoteValue;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\QuoteValue as QuoteValueResource;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    protected function _construct()
    {
        $this->_init(
            QuoteValue::class,
            QuoteValueResource::class
        );
    }

    /**
     * @return $this
     */
    public function addAttributesToSelect(): Collection
    {
        $this->join(
            ['a' => $this->getTable(LoginAttribute::TABLE)],
            'main_table.attribute_id = a.attribute_id',
            '*'
        );

        return $this;
    }
}
