<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\ResourceModel;

use Amasty\CustomerLoginAttributes\Api\Data\QuoteValueInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class QuoteValue extends AbstractDb
{
    public const TABLE_NAME = 'amasty_customer_login_attribute_quote_value';

    public function _construct()
    {
        $this->_init(self::TABLE_NAME, QuoteValueInterface::VALUE_ID);
    }

    /**
     * @param int $cartId
     * @param array $values Format:
     *              array(array('quote_id' => '<quote_id>', 'attribute_id' => '<attribute_id>', 'value' => '<value>'))
     * @return void
     */
    public function replaceValues(int $cartId, array $values): void
    {
        $this->getConnection()->delete($this->getMainTable(), ['quote_id = ?' => $cartId]);
        if ($values) {
            $this->getConnection()->insertMultiple($this->getMainTable(), $values);
        }
    }
}
