<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    protected function _construct()
    {
        $this->_init(
            LoginAttributeCustomerValue::class,
            \Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue::class
        );
    }

    /**
     * @return $this
     */
    public function addAttributesToSelect()
    {
        $this->join(
            ['a' => $this->getTable(LoginAttribute::TABLE)],
            'main_table.attribute_id = a.attribute_id',
            '*'
        );

        return $this;
    }
}
